/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import ej.annotation.Nullable;
import java.io.IOException;
import java.io.PipedReader;
import java.io.Writer;

public class PipedWriter
extends Writer {
    @Nullable
    private PipedReader sink;
    private boolean closed = false;

    public PipedWriter(PipedReader snk) throws IOException {
        this.connect(snk);
    }

    public PipedWriter() {
    }

    public synchronized void connect(PipedReader snk) throws IOException {
        if (snk.connected || this.sink != null) {
            throw new IOException("Already connected");
        }
        if (snk.closedByReader || this.closed) {
            throw new IOException("Pipe closed");
        }
        this.sink = snk;
        snk.in = -1;
        snk.out = 0;
        snk.connected = true;
    }

    @Override
    public void write(int c) throws IOException {
        PipedReader sink = this.sink;
        if (sink == null) {
            throw new IOException("Pipe not connected");
        }
        sink.receive(c);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        PipedReader sink = this.sink;
        if (sink == null) {
            throw new IOException("Pipe not connected");
        }
        if ((off | len | off + len | cbuf.length - (off + len)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        sink.receive(cbuf, off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void flush() throws IOException {
        PipedReader sink = this.sink;
        if (sink != null) {
            if (sink.closedByReader || this.closed) {
                throw new IOException("Pipe closed");
            }
            PipedReader pipedReader = sink;
            synchronized (pipedReader) {
                sink.notifyAll();
            }
        }
    }

    @Override
    public void close() throws IOException {
        PipedReader sink = this.sink;
        this.closed = true;
        if (sink != null) {
            sink.receivedLast();
        }
    }
}

