/*
 * Decompiled with CFR 0.152.
 */
package ej.microui.display;

import ej.microui.display.LLUIDisplay;
import ej.microui.display.MicroUIFont;
import ej.microui.display.MicroUIGraphicsContext;
import ej.microui.display.MicroUIImage;
import ej.microui.display.MicroUIRenderableString;

public class LLUIPainter {
    public static final int DRAWING_SUCCESS = 0;
    public static final int DRAWING_LOG_ERROR = Integer.MIN_VALUE;
    public static final int DRAWING_LOG_NOT_IMPLEMENTED = 1;
    public static final int DRAWING_LOG_FORBIDDEN = 2;
    public static final int DRAWING_LOG_OUT_OF_MEMORY = 4;
    public static final int DRAWING_LOG_CLIP_MODIFIED = 8;
    public static final int DRAWING_LOG_MISSING_CHARACTER = 16;
    public static final int DRAWING_LOG_LIBRARY_INCIDENT = 0x20000000;
    public static final int DRAWING_LOG_UNKNOWN_INCIDENT = 0x40000000;

    private LLUIPainter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writePixel(byte[] target, int x, int y) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing() && gc.isPointInClip(x, y)) {
                gc.configureClip(false);
                LLUIDisplay.Instance.getUIDrawer(gc).writePixel(gc, x, y);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawLine(byte[] target, int x1, int y1, int x2, int y2) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing()) {
                LLUIDisplay.Instance.getUIDrawer(gc).drawLine(gc, x1, y1, x2, y2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawHorizontalLine(byte[] target, int x, int y, int width) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing() && width > 0) {
                int x1 = x;
                int x2 = x + width - 1;
                gc.configureClip(!gc.isHorizontalLineInClip(x1, x2, y));
                LLUIDisplay.Instance.getUIDrawer(gc).drawHorizontalLine(gc, x1, x2, y);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawVerticalLine(byte[] target, int x, int y, int height) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing() && height > 0) {
                int y1 = y;
                int y2 = y + height - 1;
                gc.configureClip(!gc.isVerticalLineInClip(y1, y2, x));
                LLUIDisplay.Instance.getUIDrawer(gc).drawVerticalLine(gc, x, y1, y2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawRectangle(byte[] target, int x, int y, int width, int height) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing() && width > 0 && height > 0) {
                int x1 = x;
                int y1 = y;
                int x2 = x + width - 1;
                int y2 = y + height - 1;
                gc.configureClip(!gc.isRectangleInClip(x1, y1, x2, y2));
                LLUIDisplay.Instance.getUIDrawer(gc).drawRectangle(gc, x1, y1, x2, y2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fillRectangle(byte[] target, int x, int y, int width, int height) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing() && width > 0 && height > 0) {
                int x1 = x;
                int y1 = y;
                int x2 = x + width - 1;
                int y2 = y + height - 1;
                gc.configureClip(!gc.isRectangleInClip(x1, y1, x2, y2));
                LLUIDisplay.Instance.getUIDrawer(gc).fillRectangle(gc, x1, y1, x2, y2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawRoundedRectangle(byte[] target, int x, int y, int width, int height, int arcWidth, int arcHeight) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing() && width > 0 && height > 0) {
                gc.configureClip(!gc.isRegionInClip(x, y, width, height));
                LLUIDisplay.Instance.getUIDrawer(gc).drawRoundedRectangle(gc, x, y, width, height, arcWidth, arcHeight);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fillRoundedRectangle(byte[] target, int x, int y, int width, int height, int arcWidth, int arcHeight) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing() && width > 0 && height > 0) {
                gc.configureClip(!gc.isRegionInClip(x, y, width, height));
                LLUIDisplay.Instance.getUIDrawer(gc).fillRoundedRectangle(gc, x, y, width, height, arcWidth, arcHeight);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawCircleArc(byte[] target, int x, int y, int diameter, float startAngle, float arcAngle) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing() && diameter > 0 && arcAngle != 0.0f) {
                gc.configureClip(!gc.isRegionInClip(x, y, diameter, diameter));
                LLUIDisplay.Instance.getUIDrawer(gc).drawCircleArc(gc, x, y, diameter, startAngle, arcAngle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawEllipseArc(byte[] target, int x, int y, int width, int height, float startAngle, float arcAngle) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing() && width > 0 && height > 0 && arcAngle != 0.0f) {
                gc.configureClip(!gc.isRegionInClip(x, y, width, height));
                LLUIDisplay.Instance.getUIDrawer(gc).drawEllipseArc(gc, x, y, width, height, startAngle, arcAngle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fillCircleArc(byte[] target, int x, int y, int diameter, float startAngle, float arcAngle) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing() && diameter > 0 && arcAngle != 0.0f) {
                gc.configureClip(!gc.isRegionInClip(x, y, diameter, diameter));
                LLUIDisplay.Instance.getUIDrawer(gc).fillCircleArc(gc, x, y, diameter, startAngle, arcAngle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fillEllipseArc(byte[] target, int x, int y, int width, int height, float startAngle, float arcAngle) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing() && width > 0 && height > 0 && arcAngle != 0.0f) {
                gc.configureClip(!gc.isRegionInClip(x, y, width, height));
                LLUIDisplay.Instance.getUIDrawer(gc).fillEllipseArc(gc, x, y, width, height, startAngle, arcAngle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawEllipse(byte[] target, int x, int y, int width, int height) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing() && width > 0 && height > 0) {
                gc.configureClip(!gc.isRegionInClip(x, y, width, height));
                LLUIDisplay.Instance.getUIDrawer(gc).drawEllipse(gc, x, y, width, height);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fillEllipse(byte[] target, int x, int y, int width, int height) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing() && width > 0 && height > 0) {
                gc.configureClip(!gc.isRegionInClip(x, y, width, height));
                LLUIDisplay.Instance.getUIDrawer(gc).fillEllipse(gc, x, y, width, height);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawCircle(byte[] target, int x, int y, int diameter) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing() && diameter > 0) {
                gc.configureClip(!gc.isRegionInClip(x, y, diameter, diameter));
                LLUIDisplay.Instance.getUIDrawer(gc).drawCircle(gc, x, y, diameter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fillCircle(byte[] target, int x, int y, int diameter) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing() && diameter > 0) {
                gc.configureClip(!gc.isRegionInClip(x, y, diameter, diameter));
                LLUIDisplay.Instance.getUIDrawer(gc).fillCircle(gc, x, y, diameter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawImage(byte[] target, byte[] source, int regionX, int regionY, int width, int height, int x, int y, int alpha) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            MicroUIImage image = graphicsEngine.mapMicroUIImage(source);
            if (gc.requestDrawing() && !image.isClosed() && alpha > 0) {
                image = graphicsEngine.getSource(image);
                if (regionX < 0) {
                    width += regionX;
                    x -= regionX;
                    regionX = 0;
                }
                if (regionX + width > image.getWidth()) {
                    width = image.getWidth() - regionX;
                }
                if (regionY < 0) {
                    height += regionY;
                    y -= regionY;
                    regionY = 0;
                }
                if (regionY + height > image.getHeight()) {
                    height = image.getHeight() - regionY;
                }
                if (x < 0) {
                    width += x;
                    regionX -= x;
                    x = 0;
                }
                if (x + width > gc.getWidth()) {
                    width = gc.getWidth() - x;
                }
                if (y < 0) {
                    height += y;
                    regionY -= y;
                    y = 0;
                }
                if (y + height > gc.getHeight()) {
                    height = gc.getHeight() - y;
                }
                if (width > 0 && height > 0) {
                    gc.configureClip(!gc.isRegionInClip(x, y, width, height));
                    LLUIDisplay.Instance.getUIDrawer(gc).drawImage(gc, image, regionX, regionY, width, height, x, y, alpha);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawString(byte[] target, char[] chars, int offset, int length, byte[] fontData, int x, int y) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            MicroUIFont font = graphicsEngine.mapMicroUIFont(fontData);
            char[] string = graphicsEngine.mapString(chars, offset, length);
            if (gc.requestDrawing()) {
                LLUIDisplay.Instance.getUIDrawer(gc).drawString(gc, string, font, x, y);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int stringWidth(char[] chars, int offset, int length, byte[] fontData) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIFont font = graphicsEngine.mapMicroUIFont(fontData);
            char[] string = graphicsEngine.mapString(chars, offset, length);
            return LLUIDisplay.Instance.getUIFontDrawer(font).stringWidth(string, font);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawRenderableString(byte[] target, char[] chars, int offset, int length, byte[] fontData, int charsWidth, byte[] renderableStringSNIContext, int x, int y) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            MicroUIFont font = graphicsEngine.mapMicroUIFont(fontData);
            char[] string = graphicsEngine.mapString(chars, offset, length);
            MicroUIRenderableString renderableString = graphicsEngine.mapMicroUIRenderableString(renderableStringSNIContext);
            if (gc.requestDrawing()) {
                LLUIDisplay.Instance.getUIDrawer(gc).drawRenderableString(gc, string, font, charsWidth, renderableString, x, y);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int initializeRenderableStringSNIContext(char[] chars, int offset, int length, byte[] fontData, byte[] renderableStringSNIContext) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIFont font = graphicsEngine.mapMicroUIFont(fontData);
            char[] string = graphicsEngine.mapString(chars, offset, length);
            MicroUIRenderableString renderableString = graphicsEngine.mapMicroUIRenderableString(renderableStringSNIContext);
            return LLUIDisplay.Instance.getUIFontDrawer(font).initializeRenderableStringSNIContext(string, font, renderableString);
        }
    }
}

