/*
 * Decompiled with CFR 0.152.
 */
package ej.service.loader;

import ej.annotation.Nullable;
import ej.basictool.map.PackedMap;
import ej.service.ServiceLoader;
import ej.service.ServiceLoadingException;
import ej.service.ServicePermission;

public abstract class SimpleServiceLoader
implements ServiceLoader {
    protected final PackedMap<Class<?>, Object> services = new PackedMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public <T> T getService(Class<T> service) {
        this.checkServicePermission(service, "get");
        Class<T> clazz = service;
        synchronized (clazz) {
            PackedMap<Class<?>, Object> services = this.services;
            Object cachedService = services.get(service);
            if (cachedService != null) {
                return (T)cachedService;
            }
            return this.createAlternativeImplementation(service);
        }
    }

    protected <T> void checkServicePermission(Class<T> service, String action) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            String className = this.getClass().getSimpleName();
            securityManager.checkPermission(new ServicePermission(className, service, action));
        }
    }

    @Nullable
    protected <T> T createAlternativeImplementation(Class<T> service) throws ServiceLoadingException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> void putService(Class<T> service, T instance) {
        PackedMap<Class<?>, Object> packedMap = this.services;
        synchronized (packedMap) {
            this.services.put(service, instance);
        }
    }
}

