/*
 * Decompiled with CFR 0.152.
 */
package ej.websocket;

import ej.websocket.ConnectionStates;
import ej.websocket.Endpoint;
import ej.websocket.Messages;
import ej.websocket.OnTimeOutCloser;
import ej.websocket.ReasonForClosure;
import ej.websocket.Receiver;
import ej.websocket.ServerException;
import ej.websocket.WebSocketException;
import ej.websocket.WebSocketURI;
import ej.websocket.frame.ClientFrameBuilder;
import ej.websocket.frame.RawFrame;
import ej.websocket.http.Header;
import ej.websocket.http.HttpResponse;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Base64;
import java.util.Random;

public class WebSocket
implements AutoCloseable {
    private static final String HTTP_END_OF_LINE = "\r\n";
    private static final String RFC_WEBSOCKET_VERSION = "13";
    private static final int RFC_NONCE_KEY_LENGTH = 16;
    private InputStream is;
    private Socket socket;
    private OutputStream os;
    private ConnectionStates currentState;
    private final WebSocketURI uri;
    private final Endpoint endpoint;
    private final ClientFrameBuilder frameBuilder;
    private OnTimeOutCloser onTimeOutCloser;

    public WebSocket(WebSocketURI uri, Endpoint endpoint) throws NullPointerException {
        if (endpoint == null) {
            throw new NullPointerException();
        }
        if (uri == null) {
            throw new NullPointerException();
        }
        this.uri = uri;
        this.endpoint = endpoint;
        this.currentState = ConnectionStates.NEW;
        this.frameBuilder = new ClientFrameBuilder();
    }

    public void connect() throws IllegalArgumentException, WebSocketException, ServerException {
        if (this.currentState != ConnectionStates.NEW) {
            throw new IllegalStateException();
        }
        this.currentState = ConnectionStates.CONNECTING;
        try {
            this.setupSocket();
            this.is = new BufferedInputStream(this.socket.getInputStream());
            this.os = this.socket.getOutputStream();
        }
        catch (IOException e) {
            this.closeUnderlyingTCPConnection();
            throw new WebSocketException(e);
        }
        this.performOpeningHandshake();
        this.currentState = ConnectionStates.OPEN;
        new Thread((Runnable)new Receiver(this), "Websocket Receiver").start();
        this.endpoint.onOpen(this);
    }

    protected void setupSocket() throws IOException {
        this.socket = new Socket(this.uri.getHost(), this.uri.getPort());
    }

    protected void setSocket(Socket socket) {
        this.socket = socket;
    }

    public ConnectionStates getCurrentState() {
        return this.currentState;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    InputStream getInputStream() {
        return this.is;
    }

    OnTimeOutCloser getOnTimeOutCloser() {
        return this.onTimeOutCloser;
    }

    public WebSocketURI getURI() {
        return this.uri;
    }

    public synchronized void close(ReasonForClosure reasonForClosure) throws IOException {
        Messages.LOGGER.log('F', Messages.CATEGORY, 15, new Object[]{this, reasonForClosure});
        this.checkOpen();
        RawFrame f = this.frameBuilder.buildCloseFrame(reasonForClosure);
        this.os.write(f.getBytes());
        this.currentState = ConnectionStates.CLOSING;
        this.onTimeOutCloser = new OnTimeOutCloser(this);
        this.onTimeOutCloser.schedule();
    }

    @Override
    public synchronized void close() throws IOException {
        try {
            this.close(new ReasonForClosure(1000, null));
        }
        catch (IllegalStateException e) {
            Messages.LOGGER.log('G', Messages.CATEGORY, 16, (Throwable)e, new Object[]{this});
        }
    }

    public synchronized void ping(byte[] payload) throws IllegalStateException, IOException {
        Messages.LOGGER.log('F', Messages.CATEGORY, 19, new Object[]{this});
        this.checkOpen();
        RawFrame f = this.frameBuilder.buildPingFrame(payload);
        this.os.write(f.getBytes());
    }

    public synchronized void ping() throws IllegalStateException, IOException {
        this.ping(null);
    }

    public synchronized void pong(byte[] payload) throws IllegalStateException, IOException {
        Messages.LOGGER.log('F', Messages.CATEGORY, 20, new Object[]{this});
        this.checkOpen();
        RawFrame f = this.frameBuilder.buildPongFrame(payload);
        this.os.write(f.getBytes());
    }

    public synchronized void pong() throws IllegalStateException, IOException {
        this.pong(null);
    }

    public synchronized void sendBinary(byte[] binary) throws IllegalStateException, IOException {
        Messages.LOGGER.log('F', Messages.CATEGORY, 18, new Object[]{this, binary});
        this.checkOpen();
        RawFrame f = this.frameBuilder.buildBinaryFrame(binary);
        this.os.write(f.getBytes());
    }

    public synchronized void sendText(String text) throws IllegalStateException, IOException {
        Messages.LOGGER.log('F', Messages.CATEGORY, 17, new Object[]{this, text});
        this.checkOpen();
        RawFrame f = this.frameBuilder.buildTextFrame(text);
        this.os.write(f.getBytes());
    }

    void respondToClosingHandshake(ReasonForClosure reasonForClosure) throws IOException {
        Messages.LOGGER.log('F', Messages.CATEGORY, 21, new Object[]{this});
        RawFrame f = this.frameBuilder.buildCloseFrame(reasonForClosure);
        this.os.write(f.getBytes());
        this.currentState = ConnectionStates.CLOSING;
        this.closeUnderlyingTCPConnection();
    }

    void closeUnderlyingTCPConnection() {
        Messages.LOGGER.log('F', Messages.CATEGORY, 22, new Object[]{this});
        this.currentState = ConnectionStates.CLOSED;
        try {
            if (this.is != null) {
                this.is.close();
            }
        }
        catch (IOException e) {
            Messages.LOGGER.log('G', Messages.CATEGORY, -255, new Object[]{this, e});
        }
        try {
            if (this.os != null) {
                this.os.close();
            }
        }
        catch (IOException e) {
            Messages.LOGGER.log('G', Messages.CATEGORY, -255, new Object[]{this, e});
        }
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException e) {
            Messages.LOGGER.log('G', Messages.CATEGORY, -255, new Object[]{this, e});
        }
    }

    private void checkOpen() {
        if (this.currentState != ConnectionStates.OPEN) {
            throw new IllegalStateException();
        }
    }

    private boolean isUsingDefaultPort() {
        return this.uri.getPort() == 80;
    }

    private void performOpeningHandshake() throws WebSocketException, ServerException {
        HttpResponse response;
        byte[] nonceBytes = new byte[16];
        new Random(System.currentTimeMillis()).nextBytes(nonceBytes);
        String nonce = Base64.getEncoder().encodeToString(nonceBytes);
        try {
            this.sendOpeningHandshake(nonce);
        }
        catch (IOException e) {
            this.closeUnderlyingTCPConnection();
            throw new WebSocketException(e);
        }
        try {
            response = new HttpResponse(this.is);
            Messages.LOGGER.log('G', Messages.CATEGORY, 23, new Object[]{this, response});
        }
        catch (IOException e) {
            this.closeUnderlyingTCPConnection();
            throw new WebSocketException(e);
        }
        if (!this.validateResponse(response, nonce)) {
            this.closeUnderlyingTCPConnection();
            ServerException se = new ServerException();
            int serverStatusCode = response.getStatusLine().getStatusCode();
            se.setHttpStatusCode(serverStatusCode);
            throw se;
        }
    }

    private void sendOpeningHandshake(String nonce) throws IOException {
        Messages.LOGGER.log('F', Messages.CATEGORY, 24, new Object[]{this});
        StringBuilder sb = new StringBuilder();
        sb.append("GET ");
        sb.append(this.uri.getResourceName());
        sb.append(" HTTP/1.1");
        sb.append(HTTP_END_OF_LINE);
        sb.append("Host: ");
        sb.append(this.uri.getHost());
        if (!this.isUsingDefaultPort()) {
            sb.append(':');
            sb.append(this.uri.getPort());
        }
        sb.append(HTTP_END_OF_LINE);
        sb.append("Upgrade: websocket");
        sb.append(HTTP_END_OF_LINE);
        sb.append("Connection: Upgrade");
        sb.append(HTTP_END_OF_LINE);
        sb.append("Sec-WebSocket-Key: ");
        sb.append(nonce);
        sb.append(HTTP_END_OF_LINE);
        sb.append("Sec-WebSocket-Version: ");
        sb.append(RFC_WEBSOCKET_VERSION);
        sb.append(HTTP_END_OF_LINE);
        sb.append(HTTP_END_OF_LINE);
        Messages.LOGGER.log('G', Messages.CATEGORY, 25, new Object[]{this, sb});
        this.os.write(sb.toString().getBytes());
        this.os.flush();
    }

    private boolean validateResponse(HttpResponse response, String nonce) {
        if (response.getStatusLine().getStatusCode() != 101) {
            Messages.LOGGER.log('W', Messages.CATEGORY, 26, new Object[]{this});
            return false;
        }
        Header upgrade = response.getHeader("Upgrade");
        if (upgrade == null || upgrade.getValue().compareToIgnoreCase("websocket") != 0) {
            Messages.LOGGER.log('W', Messages.CATEGORY, 27, new Object[]{this});
            return false;
        }
        Header connection = response.getHeader("Connection");
        if (connection == null || connection.getValue().compareToIgnoreCase("upgrade") != 0) {
            Messages.LOGGER.log('W', Messages.CATEGORY, 28, new Object[]{this});
            return false;
        }
        Header secWebsocketAccept = response.getHeader("Sec-WebSocket-Accept");
        if (secWebsocketAccept == null) {
            Messages.LOGGER.log('W', Messages.CATEGORY, 29, new Object[]{this});
            return false;
        }
        return true;
    }
}

