/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import ej.annotation.Nullable;
import java.io.Serializable;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.time.zone.ZoneRules;
import java.time.zone.ZoneRulesException;
import java.time.zone.ZoneRulesProvider;

final class ZoneRegion
extends ZoneId
implements Serializable {
    private final String id;
    @Nullable
    private final transient ZoneRules rules;

    static ZoneRegion ofId(String zoneId, boolean checkAvailable) {
        ZoneRules rules;
        block2: {
            ZoneRegion.checkName(zoneId);
            rules = null;
            try {
                rules = ZoneRulesProvider.getRules(zoneId, true);
            }
            catch (ZoneRulesException ex) {
                if (!checkAvailable) break block2;
                throw ex;
            }
        }
        return new ZoneRegion(zoneId, rules);
    }

    private static void checkName(String zoneId) {
        int n = zoneId.length();
        if (n < 2) {
            throw new DateTimeException("Invalid ID for region-based ZoneId, invalid format: " + zoneId);
        }
        int i = 0;
        while (i < n) {
            char c = zoneId.charAt(i);
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '/' && i != 0 || c >= '0' && c <= '9' && i != 0 || c == '~' && i != 0 || c == '.' && i != 0 || c == '_' && i != 0 || c == '+' && i != 0 || c == '-' && i != 0)) {
                throw new DateTimeException("Invalid ID for region-based ZoneId, invalid format: " + zoneId);
            }
            ++i;
        }
    }

    ZoneRegion(String id, @Nullable ZoneRules rules) {
        this.id = id;
        this.rules = rules;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public ZoneRules getRules() {
        ZoneRules zoneRules = this.rules;
        if (zoneRules != null) {
            return zoneRules;
        }
        zoneRules = ZoneRulesProvider.getRules(this.id, false);
        assert (zoneRules != null);
        return zoneRules;
    }
}

