/*
 * Decompiled with CFR 0.152.
 */
package ej.motion.linear;

import ej.motion.Motion;
import ej.motion.MotionManager;
import ej.motion.linear.LinearMotion;
import ej.motion.util.TossHelper;

public class LinearMotionManager
implements MotionManager {
    @Override
    public Motion easeIn(int start, int stop, long duration) {
        return this.move(start, stop, duration);
    }

    @Override
    public Motion easeOut(int start, int stop, long duration) {
        return this.move(start, stop, duration);
    }

    @Override
    public Motion easeInOut(int start, int stop, long duration) {
        return this.move(start, stop, duration);
    }

    private Motion move(int start, int stop, long maxDuration) {
        try {
            return new LinearMotion(start, stop, maxDuration);
        }
        catch (ArithmeticException e) {
            return new LinearMotion(start, stop, 1L);
        }
    }

    @Override
    public Motion toss(int start, int min, int max, float initialSpeed, long duration) {
        int stop = TossHelper.computeExpectedStop(start, initialSpeed, duration);
        return new LinearMotion(start, stop, duration);
    }
}

