/*
 * Decompiled with CFR 0.152.
 */
package ej.library.iot.rcommand.bluetooth.commands;

import ej.rcommand.CommandReader;
import ej.rcommand.CommandSender;
import ej.rcommand.synchronous.Command;
import java.io.IOException;

public class AddServiceCommand
extends Command<Boolean> {
    private final byte[] service;
    private final int serviceSize;
    private final short[] handles;

    public AddServiceCommand(byte[] service, int serviceSize, short[] handles) {
        this.service = service;
        this.serviceSize = serviceSize;
        this.handles = handles;
    }

    public String getName() {
        return "bluetooth_add_service";
    }

    public void writeBody(CommandSender sender) throws IOException {
        sender.sendByteArray(this.service, 0, this.serviceSize);
    }

    public Boolean readResponseInternal(CommandReader reader) throws IOException {
        int numHandles = 1 + this.service[16] + this.service[17];
        boolean success = reader.readInt() == 0;
        byte[] handlesByteArray = reader.readByteArray();
        int i = 0;
        while (i < numHandles) {
            this.handles[i] = (short)((handlesByteArray[i * 2] & 0xFF) << 8 | handlesByteArray[i * 2 + 1] & 0xFF);
            ++i;
        }
        return success;
    }
}

