/*
 * Decompiled with CFR 0.152.
 */
package ej.mwt;

import ej.annotation.Nullable;
import ej.basictool.ArrayTools;
import ej.basictool.BitFieldHelper;
import ej.basictool.ThreadUtils;
import ej.microui.MicroUI;
import ej.microui.display.GraphicsContext;
import ej.mwt.Container;
import ej.mwt.Desktop;
import ej.mwt.style.Style;
import ej.mwt.style.dimension.Dimension;
import ej.mwt.util.OutlineHelper;
import ej.mwt.util.Rectangle;
import ej.mwt.util.Size;

public abstract class Widget {
    public static final int NO_CONSTRAINT = 0;
    private static final Rectangle SHARED_RECTANGLE = new Rectangle(0, 0, 0, 0);
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final int ENABLED_SHIFT = 0;
    private static final int ENABLED_MASK = 1;
    private static final int ATTACHED_SHIFT = 1;
    private static final int ATTACHED_MASK = 2;
    private static final int SHOWN_SHIFT = 2;
    private static final int SHOWN_MASK = 4;
    short x;
    short y;
    short width;
    short height;
    @Nullable
    Object parent;
    private byte flags = 0;
    @Nullable
    Style style;
    private int[] classSelectors = EMPTY_INT_ARRAY;

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setPosition(int x, int y) {
        this.x = (short)x;
        this.y = (short)y;
    }

    private void setSize(int width, int height) {
        this.width = (short)Math.max(0, width);
        this.height = (short)Math.max(0, height);
    }

    public Rectangle getContentBounds() {
        Style style = this.style;
        assert (style != null);
        Rectangle contentBounds = new Rectangle(0, 0, this.width, this.height);
        OutlineHelper.applyOutlines(contentBounds, style);
        return contentBounds;
    }

    void layOut(int x, int y, int width, int height) {
        Style style = this.style;
        assert (style != null);
        Dimension dimension = style.getDimension();
        Rectangle bounds = Widget.getSharedRectangle(x, y, width, height);
        dimension.layOut(this, bounds);
        this.setPosition(bounds.getX(), bounds.getY());
        this.setSize(bounds.getWidth(), bounds.getHeight());
        this.onLaidOut();
    }

    protected void onLaidOut() {
    }

    protected void onAttached() {
    }

    protected void onDetached() {
    }

    void setParent(Object parent, boolean attach) {
        if (this.parent != null) {
            throw new IllegalArgumentException();
        }
        this.parent = parent;
        if (attach) {
            this.setAttached();
        }
    }

    void resetParent() {
        this.setDetached();
        this.parent = null;
    }

    public boolean isAttached() {
        return BitFieldHelper.getBooleanProperty((int)this.flags, (int)2);
    }

    void setAttached() {
        if (this.isAttached()) {
            throw new IllegalArgumentException();
        }
        this.flags = (byte)BitFieldHelper.setBooleanProperty((int)this.flags, (int)2);
        try {
            this.onAttached();
        }
        catch (Exception e) {
            ThreadUtils.handleUncaughtException((Exception)e);
        }
    }

    void setDetached() {
        if (this.isAttached()) {
            this.setHidden();
            this.flags = (byte)BitFieldHelper.unsetBooleanProperty((int)this.flags, (int)2);
            try {
                this.onDetached();
            }
            catch (Exception e) {
                ThreadUtils.handleUncaughtException((Exception)e);
            }
        }
    }

    protected void onShown() {
    }

    protected void onHidden() {
    }

    public boolean isShown() {
        return BitFieldHelper.getBooleanProperty((int)this.flags, (int)4);
    }

    void setShown() {
        if (!this.isShown()) {
            this.flags = (byte)BitFieldHelper.setBooleanProperty((int)this.flags, (int)4);
            try {
                this.onShown();
            }
            catch (Exception e) {
                ThreadUtils.handleUncaughtException((Exception)e);
            }
        }
    }

    void setHidden() {
        if (this.isShown()) {
            this.flags = (byte)BitFieldHelper.unsetBooleanProperty((int)this.flags, (int)4);
            try {
                this.onHidden();
            }
            catch (Exception e) {
                ThreadUtils.handleUncaughtException((Exception)e);
            }
        }
    }

    public int getAbsoluteX() {
        int absoluteX = this.x;
        Container parent = this.getParent();
        while (parent != null) {
            absoluteX += parent.x + parent.contentX;
            parent = parent.getParent();
        }
        return absoluteX;
    }

    public int getAbsoluteY() {
        int absoluteY = this.y;
        Container parent = this.getParent();
        while (parent != null) {
            absoluteY += parent.y + parent.contentY;
            parent = parent.getParent();
        }
        return absoluteY;
    }

    public boolean isTransparent() {
        Style style = this.style;
        assert (style != null);
        Rectangle bounds = Widget.getSharedRectangle(this.x, this.y, this.width, this.height);
        style.getMargin().apply(bounds);
        return style.getBackground().isTransparent(bounds.getWidth(), bounds.getHeight());
    }

    public boolean containsWidget(Widget widget) {
        Widget ancestor = widget;
        do {
            if (ancestor != this) continue;
            return true;
        } while ((ancestor = ancestor.getParent()) != null);
        return false;
    }

    public boolean contains(int x, int y) {
        Rectangle bounds = Widget.getSharedRectangle(this.x, this.y, this.width, this.height);
        Style style = this.style;
        if (style != null) {
            style.getMargin().apply(bounds);
        }
        int boundsX = bounds.getX();
        int boundsY = bounds.getY();
        return x >= boundsX && x <= boundsX + bounds.getWidth() && y >= boundsY && y <= boundsY + bounds.getHeight();
    }

    @Nullable
    public Widget getWidgetAt(int x, int y) {
        if (this.contains(x, y)) {
            return this;
        }
        return null;
    }

    public boolean isEnabled() {
        return BitFieldHelper.getBooleanProperty((int)this.flags, (int)1);
    }

    public void setEnabled(boolean enabled) {
        this.flags = (byte)BitFieldHelper.setBooleanProperty((int)this.flags, (boolean)enabled, (int)1);
    }

    public void requestLayOut() {
        if (!this.isAttached()) {
            return;
        }
        MicroUI.callSerially((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!Widget.this.isAttached()) {
                    return;
                }
                Widget widget = Widget.this;
                short width = widget.width;
                short height = widget.height;
                Widget.this.computeOptimalSize(width, height);
                Widget.this.layOut(widget.x, widget.y, width, height);
                Widget.this.setShown();
            }
        });
        this.getDesktop().requestRender(this, 0, 0, this.width, this.height);
    }

    void computeOptimalSize(int availableWidth, int availableHeight) {
        Desktop desktop = this.getDesktop();
        Style style = desktop.getStylesheet().getStyle(this);
        this.setStyle(style);
        Dimension dimension = style.getDimension();
        Size size = new Size(availableWidth, availableHeight);
        OutlineHelper.applyOutlines(size, style);
        int horizontalOutlines = availableWidth - size.getWidth();
        int verticalOutlines = availableHeight - size.getHeight();
        if (availableWidth == 0) {
            size.setWidth(0);
        }
        if (availableHeight == 0) {
            size.setHeight(0);
        }
        dimension.getAvailableSize(this, availableWidth, availableHeight, size);
        try {
            this.computeContentOptimalSize(size);
        }
        catch (Exception e) {
            ThreadUtils.handleUncaughtException((Exception)e);
        }
        dimension.computeOptimalSize(this, availableWidth, availableHeight, size);
        this.setSize(size.getWidth() + horizontalOutlines, size.getHeight() + verticalOutlines);
    }

    protected abstract void computeContentOptimalSize(Size var1);

    public void requestRender() {
        this.requestRender(0, 0, this.width, this.height);
    }

    public void requestRender(int x, int y, int width, int height) {
        if (this.isShown()) {
            this.getDesktop().requestRender(this, x, y, width, height);
        }
    }

    public boolean handleEvent(int event) {
        return false;
    }

    void paint(GraphicsContext g) {
        if (!this.isAttached()) {
            return;
        }
        g.translate((int)this.x, (int)this.y);
        g.intersectClip(0, 0, (int)this.width, (int)this.height);
        if (g.getClipWidth() == 0 || g.getClipHeight() == 0) {
            return;
        }
        this.render(g);
    }

    public void render(GraphicsContext g) {
        Style style = this.style;
        assert (style != null);
        Size contentSize = new Size(this.width, this.height);
        OutlineHelper.applyOutlinesAndBackground(g, contentSize, style);
        try {
            this.renderContent(g, contentSize.getWidth(), contentSize.getHeight());
        }
        catch (Exception e) {
            ThreadUtils.handleUncaughtException((Exception)e);
        }
    }

    protected abstract void renderContent(GraphicsContext var1, int var2, int var3);

    @Nullable
    public Container getParent() {
        Object parent = this.parent;
        if (parent instanceof Container) {
            return (Container)parent;
        }
        return null;
    }

    public Desktop getDesktop() {
        Object parent = this.parent;
        assert (parent != null);
        if (parent instanceof Desktop) {
            return (Desktop)((Object)parent);
        }
        return ((Container)parent).getDesktop();
    }

    @Nullable
    Desktop getDesktopOrNull() {
        Object parent = this.parent;
        if (parent instanceof Desktop) {
            return (Desktop)((Object)parent);
        }
        if (parent != null) {
            return ((Container)parent).getDesktopOrNull();
        }
        return null;
    }

    public Style getStyle() {
        assert (this.style != null);
        return this.style;
    }

    public void setStyle(Style newStyle) {
        this.style = newStyle;
    }

    public void updateStyle() {
        Desktop desktop = this.getDesktopOrNull();
        if (desktop != null) {
            Style newStyle = desktop.getStylesheet().getStyle(this);
            this.setStyle(newStyle);
        }
    }

    public boolean hasClassSelector(int classSelector) {
        return ArrayTools.getIndex((int[])this.classSelectors, (int)classSelector) != -1;
    }

    public void addClassSelector(int classSelector) {
        this.classSelectors = ArrayTools.add((int[])this.classSelectors, (int)classSelector);
    }

    public void removeClassSelector(int classSelector) {
        this.classSelectors = ArrayTools.remove((int[])this.classSelectors, (int)classSelector);
    }

    public void setClassSelectors(int[] classSelectors) {
        this.classSelectors = (int[])classSelectors.clone();
    }

    public void removeAllClassSelectors() {
        this.classSelectors = EMPTY_INT_ARRAY;
    }

    public boolean isInState(int state) {
        return false;
    }

    static Rectangle getSharedRectangle(int x, int y, int width, int height) {
        SHARED_RECTANGLE.setBounds(x, y, width, height);
        return SHARED_RECTANGLE;
    }
}

