/*
 * Java
 *
 * Copyright 2015-2025 MicroEJ Corp.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.microui.display;

import java.security.Permission;

import ej.annotation.Nullable;

/**
 * This class is for image permissions.
 * <p>
 * The name is related to the image creation APIs and it symbolizes the permission's action.
 * <p>
 * The meaning of the possible permissions is defined as follows:
 * <dl>
 * <dt>canget
 * <dd>can get permission. Allows <code>Image.canGetImage(String)</code> to be called.
 * <dt>get
 * <dd>get permission. Allows <code>Image.getImage(String)</code> to be called.
 * <dt>canload
 * <dd>can load permission. Allows <code>ResourceImage.canLoadImage(String)</code> to be called.
 * <dt>load
 * <dd>load permission. Allows <code>ResourceImage.loadImage(String)</code> to be called.
 * <dt>loadwithformat
 * <dd>load with output format permission. Allows
 * <code>ResourceImage.loadImage(String, ResourceImage.OutputFormat)</code> to be called.
 * <dt>loadstream
 * <dd>load from input stream permission. Allows <code>ResourceImage.loadImage(InputStream, int)</code> to be called.
 * <dt>loadstreamwithformat
 * <dd>load from input stream with output format permission. Allows
 * <code>ResourceImage.loadImage(InputStream, int, ResourceImage.OutputFormat)</code> to be called.
 * <dt>create
 * <dd>create buffered image permission. Allows <code>BufferedImage.BufferedImage(int, int)</code> to be called.
 * <dt>createwithformat
 * <dd>create buffered image with format permission. Allows <code>BufferedImage.BufferedImage(int, int, Format)</code>
 * to be called.
 * </dl>
 *
 * @see java.security.Permission
 *
 * @since 2.0
 */
public class ImagePermission extends Permission {

	/**
	 * @deprecated use {@link #ImagePermission(String)}
	 */
	@Deprecated
	public ImagePermission() {
		super(null);
		throw new RuntimeException();
	}

	/**
	 * Creates a permission with the specified name.
	 *
	 * @param permission
	 *            the name of the <code>ImagePermission</code>.
	 */
	public ImagePermission(String permission) {
		super(permission);
		throw new RuntimeException();
	}

	@Override
	public boolean equals(@Nullable Object obj) {
		throw new RuntimeException();
	}

	@Override
	public String getActions() {
		throw new RuntimeException();
	}

	@Override
	public int hashCode() {
		throw new RuntimeException();
	}

	@Override
	public boolean implies(Permission permission) {
		throw new RuntimeException();
	}
}
