/*
 * Decompiled with CFR 0.152.
 */
package ej.microui.event;

import ej.fp.FrontPanel;
import ej.microui.event.LLUIInput;
import java.util.HashMap;
import java.util.Map;

public class EventState {
    public static final String COMMON_MICROUI_GENERATOR_TAG = "STATES";
    private static final int STATES_DRIVER_VALUE_MASK = 65280;
    private static final int STATES_DRIVER_VALUE_SHIFT = 8;
    private static final int STATES_DRIVER_STATE_MASK = 255;
    private static final int STATES_DRIVER_STATE_SHIFT = 0;
    private static final int DEFAULT_INITIAL_VALUE = 0;
    private static final HashMap<Integer, HashMap<Integer, Integer>> EventGeneratorIDtoState = new HashMap(0);

    private EventState() {
    }

    public static void sendStateEvent(int stateID, int stateValue) {
        EventState.sendStateEvent(COMMON_MICROUI_GENERATOR_TAG, stateID, stateValue);
    }

    public static void sendStateEvent(String statesEventGenerator, int stateID, int stateValue) {
        try {
            LLUIInput.sendEvent(statesEventGenerator, stateID << 0 & 0xFF | stateValue << 8 & 0xFF00);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            StringBuilder buf = new StringBuilder();
            buf.append("[");
            buf.append(EventState.class.getName());
            buf.append("] ");
            buf.append("state ");
            buf.append(stateID);
            buf.append("value ");
            buf.append(stateValue);
            buf.append(" (");
            buf.append(statesEventGenerator);
            buf.append(")");
            FrontPanel.out.println(buf.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setInitialStateValue(int eventGeneratorID, int stateID, int value) {
        HashMap<Integer, HashMap<Integer, Integer>> hashMap = EventGeneratorIDtoState;
        synchronized (hashMap) {
            Integer iEventGeneratorID = new Integer(eventGeneratorID);
            Integer iStateID = new Integer(stateID);
            Integer iValue = new Integer(value);
            HashMap<Integer, Integer> state = EventGeneratorIDtoState.get(iEventGeneratorID);
            if (state == null) {
                state = new HashMap(1);
                EventGeneratorIDtoState.put(iEventGeneratorID, state);
            }
            state.put(iStateID, iValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getInitialStateValue(int eventGeneratorID, int stateID) {
        HashMap<Integer, HashMap<Integer, Integer>> hashMap = EventGeneratorIDtoState;
        synchronized (hashMap) {
            Integer iStateID = new Integer(stateID);
            int stateValue = 0;
            for (Map.Entry<Integer, HashMap<Integer, Integer>> entry : EventGeneratorIDtoState.entrySet()) {
                Integer gen = entry.getKey();
                if (gen != eventGeneratorID) continue;
                HashMap<Integer, Integer> state = EventGeneratorIDtoState.get(gen);
                Integer iValue = state.get(iStateID);
                if (iValue == null) break;
                stateValue = iValue;
                break;
            }
            return stateValue;
        }
    }
}

