/*
 * Decompiled with CFR 0.152.
 */
package ej.microui.event;

import ej.fp.FrontPanel;
import ej.microui.event.LLUIInput;

public class EventButton {
    public static final String COMMON_MICROUI_GENERATOR_TAG = "BUTTONS";
    private static final int BUTTONS_DRIVER_ACTION_MASK = 65280;
    private static final int BUTTONS_DRIVER_ACTION_SHIFT = 8;
    private static final int BUTTONS_DRIVER_BUTTON_MASK = 255;
    private static final int BUTTONS_DRIVER_BUTTON_SHIFT = 0;
    private static final int BUTTONS_DRIVER_PRESS = 0;
    private static final int BUTTONS_DRIVER_RELEASE = 1;
    private static final int BUTTONS_DRIVER_LONG = 2;
    private static final int BUTTONS_DRIVER_REPEAT = 3;

    private EventButton() {
    }

    public static void sendPressedEvent(int buttonId) {
        EventButton.sendPressedEvent(COMMON_MICROUI_GENERATOR_TAG, buttonId);
    }

    public static void sendPressedEvent(String buttonsEventGenerator, int buttonId) {
        try {
            EventButton.sendEvent(buttonsEventGenerator, buttonId, 0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            EventButton.traceEvent(buttonsEventGenerator, buttonId, "press");
        }
    }

    public static void sendReleasedEvent(int buttonId) {
        EventButton.sendReleasedEvent(COMMON_MICROUI_GENERATOR_TAG, buttonId);
    }

    public static void sendReleasedEvent(String buttonsEventGenerator, int buttonId) {
        try {
            EventButton.sendEvent(buttonsEventGenerator, buttonId, 1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            EventButton.traceEvent(buttonsEventGenerator, buttonId, "release");
        }
    }

    public static void sendRepeatedEvent(int buttonId) {
        EventButton.sendRepeatedEvent(COMMON_MICROUI_GENERATOR_TAG, buttonId);
    }

    public static void sendRepeatedEvent(String buttonsEventGenerator, int buttonId) {
        try {
            EventButton.sendEvent(buttonsEventGenerator, buttonId, 3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            EventButton.traceEvent(buttonsEventGenerator, buttonId, "repeat");
        }
    }

    public static void sendLongEvent(int buttonId) {
        EventButton.sendLongEvent(COMMON_MICROUI_GENERATOR_TAG, buttonId);
    }

    public static void sendLongEvent(String buttonsEventGenerator, int buttonId) {
        try {
            EventButton.sendEvent(buttonsEventGenerator, buttonId, 2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            EventButton.traceEvent(buttonsEventGenerator, buttonId, "long press");
        }
    }

    private static void sendEvent(String buttonsEventGenerator, int buttonId, int event) {
        LLUIInput.sendEvent(buttonsEventGenerator, event << 8 & 0xFF00 | buttonId << 0 & 0xFF);
    }

    private static void traceEvent(String buttonsEventGenerator, int buttonId, String desc) {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        buf.append(EventButton.class.getName());
        buf.append("] ");
        buf.append(desc);
        buf.append(" button ");
        buf.append(buttonId);
        buf.append(" (");
        buf.append(buttonsEventGenerator);
        buf.append(")");
        FrontPanel.out.println(buf.toString());
    }
}

