/*
 * Java
 *
 * Copyright 2024-2025 MicroEJ Corp. All rights reserved.
 * MicroEJ Corp. PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.microui.display;

/**
 * Represents a MicroUI RenderableString.
 * <p>
 * This interface is used by several drawing methods which use a renderable string. It can be mapped on byte array given
 * as parameter in some MicroUI natives. This byte array is retrieved in MicroEJ application using the method
 * RenderableString.getSNIContext().
 *
 * @see LLUIDisplay#mapMicroUIRenderableString(byte[])
 */
public interface MicroUIRenderableString {

	/**
	 * Gets the SNI context array.
	 * <p>
	 * It is the equivalent of the the byte array given by the Font in Java when creating a renderable string.
	 *
	 * @return the SNI context
	 */
	byte[] getSNIContext();

}
