/*
 * Decompiled with CFR 0.152.
 */
package ej.basictool.map;

import ej.annotation.Nullable;
import ej.basictool.ArrayTools;
import ej.basictool.map.AbstractPackedMap;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Set;

public abstract class AbstractWeakPackedMap<K, V>
extends AbstractPackedMap<K, V> {
    public AbstractWeakPackedMap() {
    }

    public AbstractWeakPackedMap(AbstractWeakPackedMap<K, V> map) {
        super(map);
    }

    @Override
    public boolean containsKey(Object key) {
        this.clean();
        return super.containsKey(key);
    }

    @Override
    protected boolean containsUnwrappedKey(@Nullable Object key) {
        this.clean();
        if (key == null) {
            return false;
        }
        return super.containsUnwrappedKey(key);
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        this.clean();
        return super.containsValue(value);
    }

    @Override
    @Nullable
    public V get(Object key) {
        this.clean();
        return super.get(key);
    }

    @Override
    public Set<K> keySet() {
        return new WeakPackedMapKeySet(this);
    }

    @Override
    @Nullable
    public V put(K key, V value) {
        this.clean();
        return super.put(key, value);
    }

    @Override
    @Nullable
    public V remove(Object key) {
        this.clean();
        return super.remove(key);
    }

    @Override
    public int size() {
        this.clean();
        return super.size();
    }

    @Override
    protected Object wrapKey(K key) {
        return new WeakPackedMapReference<K>(key);
    }

    @Override
    protected int getWrappedKeyHashCode(Object wrappedKey) {
        return ((WeakPackedMapReference)wrappedKey).hashCode;
    }

    @Override
    @Nullable
    protected K unwrapKey(Object wrappedKey) {
        Object k = ((Reference)wrappedKey).get();
        return (K)k;
    }

    private void clean() {
        this.keysValues = AbstractWeakPackedMap.clean(this, this.keysValues);
    }

    static <K, V> Object[] clean(AbstractPackedMap<K, V> map, Object[] keysValues) {
        int size = keysValues.length / 2;
        int i = 0;
        while (i < size) {
            Object wrappedKey = keysValues[i];
            assert (wrappedKey != null);
            K object = map.unwrapKey(wrappedKey);
            if (object == null) {
                int arrayLength = keysValues.length;
                int valueIndex = arrayLength / 2 + i;
                Object[] newArray = new Object[arrayLength - 2];
                System.arraycopy(keysValues, 0, newArray, 0, i);
                System.arraycopy(keysValues, i + 1, newArray, i, valueIndex - i - 1);
                System.arraycopy(keysValues, valueIndex + 1, newArray, valueIndex - 1, arrayLength - valueIndex - 1);
                keysValues = newArray;
                --i;
                --size;
            }
            ++i;
        }
        return keysValues;
    }

    class WeakPackedMapKeySet
    extends AbstractPackedMap.PackedMapKeySet {
        public WeakPackedMapKeySet(AbstractPackedMap<K, V> map) {
            super(map);
        }

        @Override
        public Object[] toArray() {
            Object[] keysValues = AbstractWeakPackedMap.this.keysValues;
            int size = keysValues.length / 2;
            Object[] result = new Object[size];
            this.copy(keysValues, size, result);
            return result;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            Object[] keysValues = AbstractWeakPackedMap.this.keysValues;
            int size = keysValues.length / 2;
            Object[] result = a.length <= size ? a : ArrayTools.createNewArray(a, size);
            this.copy(keysValues, size, result);
            return result;
        }

        private void copy(Object[] keysValues, int size, Object[] result) {
            int ptr = 0;
            int i = 0;
            while (i < size) {
                Object wrappedKey = keysValues[i];
                assert (wrappedKey != null);
                Object unwrappedKey = AbstractWeakPackedMap.this.unwrapKey(wrappedKey);
                if (unwrappedKey != null) {
                    result[ptr++] = unwrappedKey;
                }
                ++i;
            }
        }
    }

    class WeakPackedMapReference<T>
    extends WeakReference<T> {
        private final int hashCode;

        public WeakPackedMapReference(T referent) {
            super(referent);
            this.hashCode = referent.hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

