/*
 * Java
 *
 * Copyright 2018-2021 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.basictool.map;

import ej.annotation.Nullable;

/**
 * @param <K>
 *            the type of keys maintained by this map.
 * @param <V>
 *            the type of mapped values.
 */
public class WeakPackedMap<K, V> extends AbstractWeakPackedMap<K, V> {

	/**
	 * Constructs an empty map.
	 */
	public WeakPackedMap() {
		super();
	}

	/**
	 * Constructs a map with the same mappings as the specified map.
	 *
	 * @param map
	 *            the map whose mappings are to be placed in this map.
	 * @throws NullPointerException
	 *             if the specified map is <code>null</code>.
	 */
	public WeakPackedMap(WeakPackedMap<K, V> map) {
		super(map);
	}

	@Override
	public Object clone() {
		return new WeakPackedMap<>(this);
	}

	@Override
	protected boolean isSame(Object key, @Nullable Object candidateKey) {
		return candidateKey != null && candidateKey.equals(key);
	}

}
