/*
 * Decompiled with CFR 0.152.
 */
package ej.microvg.image;

import ej.microvg.image.ImageGenerator;
import ej.microvg.image.LinearGradient;
import ej.microvg.image.Path;
import ej.microvg.image.pathdata.TwoArraysPathData;
import java.awt.Color;
import java.nio.ByteBuffer;

public class NemaImageGenerator
implements ImageGenerator {
    private static final byte CMD_CLOSE = 0;
    private static final byte CMD_MOVE = 1;
    private static final byte CMD_MOVE_REL = 17;
    private static final byte CMD_LINE = 2;
    private static final byte CMD_LINE_REL = 18;
    private static final byte CMD_QUAD = 5;
    private static final byte CMD_QUAD_REL = 21;
    private static final byte CMD_CUBIC = 6;
    private static final byte CMD_CUBIC_REL = 22;
    private final TwoArraysPathData pathData = new TwoArraysPathData();

    public NemaImageGenerator(ImageGenerator.Format format) {
    }

    @Override
    public int encodeCommand(ImageGenerator.Command command) {
        switch (command) {
            default: {
                return 0;
            }
            case COMMAND_MOVE: {
                return 1;
            }
            case COMMAND_MOVE_REL: {
                return 17;
            }
            case COMMAND_LINE: {
                return 2;
            }
            case COMMAND_LINE_REL: {
                return 18;
            }
            case COMMAND_QUAD: {
                return 5;
            }
            case COMMAND_QUAD_REL: {
                return 21;
            }
            case COMMAND_CUBIC: {
                return 6;
            }
            case COMMAND_CUBIC_REL: 
        }
        return 22;
    }

    @Override
    public int encodeColor(Color color, float opacity) {
        int newColor = 0;
        newColor |= color.getRed();
        newColor |= color.getGreen() << 8;
        newColor |= color.getBlue() << 16;
        return newColor |= (int)(opacity * 255.0f) << 24;
    }

    @Override
    public byte[] encodePath(Path path) {
        TwoArraysPathData pathData = this.pathData;
        path.encode(pathData);
        byte[] commands = pathData.getPathCommands();
        byte[] params = pathData.getPathParams();
        int commandLength = commands.length;
        int paramLength = params.length;
        int size = 20 + paramLength + commandLength;
        ByteBuffer buffer = this.newByteBuffer(size);
        buffer.putFloat((float)path.getMinX());
        buffer.putFloat((float)path.getMinY());
        buffer.putFloat((float)path.getMaxX());
        buffer.putFloat((float)path.getMaxY());
        buffer.putChar((char)commandLength);
        buffer.putChar((char)(paramLength / pathData.getFormat().getUnitSize()));
        buffer.put(params, 0, paramLength);
        buffer.put(commands, 0, commandLength);
        return buffer.array();
    }

    @Override
    public byte[] encodeGradient(LinearGradient gradient) {
        LinearGradient.LinearGradientStop stop;
        int size = 20 + gradient.getStops().length * 20;
        ByteBuffer buffer = this.newByteBuffer(size);
        LinearGradient.LinearGradientStop[] stops = gradient.getStops();
        buffer.putFloat(gradient.getXStart());
        buffer.putFloat(gradient.getYStart());
        buffer.putFloat(gradient.getXEnd());
        buffer.putFloat(gradient.getYEnd());
        buffer.putInt(stops.length);
        LinearGradient.LinearGradientStop[] linearGradientStopArray = stops;
        int n = stops.length;
        int n2 = 0;
        while (n2 < n) {
            stop = linearGradientStopArray[n2];
            buffer.putFloat(stop.getPosition());
            ++n2;
        }
        linearGradientStopArray = stops;
        n = stops.length;
        n2 = 0;
        while (n2 < n) {
            stop = linearGradientStopArray[n2];
            Color color = stop.getColor();
            buffer.putFloat(color.getRed());
            buffer.putFloat(color.getGreen());
            buffer.putFloat(color.getBlue());
            buffer.putFloat(stop.getOpacity() * 255.0f);
            ++n2;
        }
        return buffer.array();
    }
}

