/*
 * Java
 *
 * Copyright 2020-2025 MicroEJ Corp. All rights reserved.
 * MicroEJ Corp. PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.microvg.image.pathdata;

import java.nio.ByteBuffer;

/**
 * Decodes a path encoded by 16-bit values: the commands and the commands' attributes are encoded by 16-bit signed
 * values.
 */
public class SingleArrayPathDataS16 extends SingleArrayPathData {

	/**
	 * Creates a decoder that will decode the path encoded in a single byte array.
	 *
	 * @param buffer
	 *            the encoded path (the first available data is the first path's command)
	 */
	public SingleArrayPathDataS16(ByteBuffer buffer) {
		super(buffer);
	}

	@Override
	public int nextCommand() {
		return this.buffer.getShort();
	}

	@Override
	public double nextCoordinate() {
		return this.buffer.getShort();
	}

}
