/*
 * Java
 *
 * Copyright 2020-2025 MicroEJ Corp. All rights reserved.
 * MicroEJ Corp. PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.microvg.image.pathdata;

import ej.microvg.CommandDecoder;

/**
 * A path data organizes the data of a path: the commands and their parameters. It also holds the path's bounds.
 */
public interface PathData {

	/**
	 * Tells whether it remains at least one command to decode.
	 *
	 * @return {@code true} if, and only if, there is at least one command remaining in this path
	 */
	boolean hasRemainingCommand();

	/**
	 * Gets next encoded command from path. The command will be decoded later thanks
	 * {@link CommandDecoder#decodeCommand(int)}.
	 *
	 * @return the next command
	 */
	int nextCommand();

	/**
	 * Gets next point coordinate from path.
	 *
	 * @return the next coordinate
	 */
	double nextCoordinate();
}
