/*
 * Decompiled with CFR 0.152.
 */
package ej.microui.event;

import ej.microui.event.EventQueue;

public class LLUIInput {
    private static final int EVENT_PUMP = 0x7000000;
    private static final int EVENT_ID_MASK = 255;
    private static final int EVENT_ID_SHIFT = 16;
    private static final int EVENT_DATA_MASK = 65535;
    private static final int EVENT_DATA_SHIFT = 0;

    private LLUIInput() {
    }

    public static int getType(int event) {
        return event >> 16 & 0xFF;
    }

    public static int getData(int event) {
        return event >> 0 & 0xFFFF;
    }

    public static int buildEvent(String generatorId, int data) {
        return LLUIInput.buildEvent(LLUIInput.getEventGeneratorID(generatorId), data);
    }

    public static int buildEvent(int generatorId, int data) {
        return 0x7000000 | (generatorId & 0xFF) << 16 | (data & 0xFFFF) << 0;
    }

    public static void sendEvent(int event) {
        LLUIInput.getEventQueue().enqueudEvent(event);
    }

    public static void sendEvents(int[] events) {
        LLUIInput.getEventQueue().enqueudEvents(events);
    }

    public static void sendEvent(String generatorId, int data) {
        LLUIInput.sendEvent(LLUIInput.buildEvent(generatorId, data));
    }

    public static void sendEvent(int generatorId, int data) {
        LLUIInput.sendEvent(LLUIInput.buildEvent(generatorId, data));
    }

    private static int getEventGeneratorID(String eventGenerator) {
        try {
            String eventGeneratorID = System.getProperty("com.is2t.microbsp.microui.io.eventgenerator." + eventGenerator);
            return Integer.parseInt(eventGeneratorID);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("MicroUI events generator ID '" + eventGenerator + "' is unknown.");
        }
    }

    private static EventQueue getEventQueue() {
        return EventQueue.get();
    }
}

