/*
 * Decompiled with CFR 0.152.
 */
package com.microej.kf.util.property;

import ej.annotation.Nullable;
import ej.basictool.map.PackedMap;
import ej.kf.Feature;
import ej.kf.FeatureStateListener;
import ej.kf.Kernel;
import ej.kf.Module;
import ej.property.SharedPropertyRegistry;
import ej.property.registry.SimplePropertyRegistry;

public class SharedPropertyRegistryKF
extends SimplePropertyRegistry
implements SharedPropertyRegistry,
FeatureStateListener {
    private final PackedMap<Feature, PackedMap<String, String>> sharedPropertiesByFeatures = new PackedMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String setProperty(String key, String value) {
        PackedMap featureProperties;
        PackedMap sharedPropertiesByFeatures;
        Module contextOwner = Kernel.getContextOwner();
        if (contextOwner == Kernel.getInstance()) {
            return super.setProperty(key, value);
        }
        Kernel.enter();
        this.checkPropertyPermission(key, "set");
        PackedMap packedMap = sharedPropertiesByFeatures = this.sharedPropertiesByFeatures;
        synchronized (packedMap) {
            Feature featureOwner;
            if (sharedPropertiesByFeatures.isEmpty()) {
                Kernel.addFeatureStateListener((FeatureStateListener)this);
            }
            if ((featureProperties = (PackedMap)sharedPropertiesByFeatures.get((Object)(featureOwner = (Feature)contextOwner))) == null) {
                featureProperties = new PackedMap();
                sharedPropertiesByFeatures.put((Object)featureOwner, (Object)featureProperties);
            }
        }
        packedMap = featureProperties;
        synchronized (packedMap) {
            return (String)featureProperties.put((Object)key, (Object)value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String removeProperty(String key) {
        Module contextOwner = Kernel.getContextOwner();
        if (contextOwner == Kernel.getInstance()) {
            return super.removeProperty(key);
        }
        Kernel.enter();
        this.checkPropertyPermission(key, "remove");
        PackedMap<Feature, PackedMap<String, String>> sharedPropertiesByFeatures = this.sharedPropertiesByFeatures;
        PackedMap sharedProperties = (PackedMap)sharedPropertiesByFeatures.get((Object)contextOwner);
        if (sharedProperties != null) {
            PackedMap packedMap = sharedProperties;
            synchronized (packedMap) {
                String result = (String)sharedProperties.remove((Object)key);
                if (result != null) {
                    if (sharedProperties.isEmpty()) {
                        PackedMap<Feature, PackedMap<String, String>> packedMap2 = sharedPropertiesByFeatures;
                        synchronized (packedMap2) {
                            sharedPropertiesByFeatures.remove((Object)contextOwner);
                            if (sharedPropertiesByFeatures.isEmpty()) {
                                Kernel.removeFeatureStateListener((FeatureStateListener)this);
                            }
                        }
                    }
                    return result;
                }
            }
        }
        return null;
    }

    @Nullable
    public String getProperty(String key) {
        String value;
        PackedMap sharedProperties;
        this.checkPropertyPermission(key, "get");
        Module contextOwner = Kernel.getContextOwner();
        if (!Kernel.isInKernelMode() && (sharedProperties = (PackedMap)this.sharedPropertiesByFeatures.get((Object)contextOwner)) != null && (value = (String)sharedProperties.get((Object)key)) != null) {
            return value;
        }
        String value2 = super.getProperty(key);
        if (value2 != null) {
            return value2;
        }
        Kernel.enter();
        String keyKernel = new String(key);
        for (PackedMap sharedProperties2 : this.sharedPropertiesByFeatures.values()) {
            value2 = (String)sharedProperties2.get((Object)keyKernel);
            if (value2 == null) continue;
            try {
                value2 = (String)Kernel.clone((Object)value2, (Module)contextOwner);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {}
            return value2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateChanged(@Nullable Feature feature, @Nullable Feature.State previousState) {
        if (feature != null && feature.getState() == Feature.State.STOPPED) {
            PackedMap<Feature, PackedMap<String, String>> packedMap = this.sharedPropertiesByFeatures;
            synchronized (packedMap) {
                this.sharedPropertiesByFeatures.remove((Object)feature);
            }
        }
    }
}

