/*
 * Decompiled with CFR 0.152.
 */
package com.microej.kf.util.observable;

import ej.annotation.Nullable;
import ej.kf.Feature;
import ej.kf.FeatureStateListener;
import ej.kf.Kernel;
import ej.kf.Module;
import ej.observable.Observable;
import ej.observable.Observer;

public class KernelObservable
extends Observable {
    @Nullable
    private FeatureStateListener featureStateListener;

    public KernelObservable() {
        if (Kernel.getContextOwner() != Kernel.getInstance()) {
            throw new IllegalAccessError();
        }
        this.featureStateListener = new FeatureStateListener(){

            public void stateChanged(@Nullable Feature feature, @Nullable Feature.State previousState) {
                if (feature != null && feature.getState() == Feature.State.STOPPED) {
                    KernelObservable.this.deleteObservers((Module)feature);
                }
            }
        };
        Kernel.addFeatureStateListener((FeatureStateListener)this.featureStateListener);
    }

    public void dispose() {
        FeatureStateListener featureStateListener = this.featureStateListener;
        if (featureStateListener != null) {
            this.deleteObservers();
            Kernel.removeFeatureStateListener((FeatureStateListener)featureStateListener);
            this.featureStateListener = null;
        }
    }

    public void addObserver(Observer observer) {
        if (this.featureStateListener == null) {
            throw new IllegalStateException();
        }
        Kernel.enter();
        super.addObserver(observer);
    }

    private void deleteObservers(Module module) {
        Observer[] observers;
        Observer[] observerArray = observers = this.getObservers();
        int n = observers.length;
        int n2 = 0;
        while (n2 < n) {
            Observer observer = observerArray[n2];
            assert (observer != null);
            if (Kernel.getOwner((Object)observer) == module) {
                this.deleteObserver(observer);
            }
            ++n2;
        }
    }
}

