/*
 * Decompiled with CFR 0.152.
 */
package com.microej.kf.util.control.fs;

import com.microej.kf.util.module.SandboxedModule;
import com.microej.kf.util.module.SandboxedModuleHelper;
import ej.service.ServiceFactory;
import java.io.IOException;
import java.io.RandomAccessFile;

public class WriteRandomAccessFile {
    private final long nbWriteBytes;

    public WriteRandomAccessFile(RandomAccessFile file, int nbWriteBytes) throws IOException {
        long length = file.length();
        long position = file.getFilePointer();
        long overwriteLength = length - position;
        long remainingWriteLength = (long)nbWriteBytes - overwriteLength;
        this.nbWriteBytes = remainingWriteLength < 0L ? 0L : remainingWriteLength;
    }

    public long getNbBytes() {
        return this.nbWriteBytes;
    }

    public void onStart() throws SecurityException {
        SandboxedModuleHelper cmh = (SandboxedModuleHelper)ServiceFactory.getRequiredService(SandboxedModuleHelper.class);
        SandboxedModule currentModule = cmh.getCurrentModule();
        currentModule.getFileSystemResourceController().onStart(currentModule, this);
    }

    public void onEnd(boolean endWithSuccess) {
        SandboxedModuleHelper cmh = (SandboxedModuleHelper)ServiceFactory.getRequiredService(SandboxedModuleHelper.class);
        SandboxedModule currentModule = cmh.getCurrentModule();
        currentModule.getFileSystemResourceController().onEnd(currentModule, this, endWithSuccess);
    }
}

