/*
 * Decompiled with CFR 0.152.
 */
package com.microej.kf.util.control.fs;

import com.microej.kf.util.control.fs.AbstractFile;
import com.microej.kf.util.module.SandboxedModule;
import com.microej.kf.util.module.SandboxedModuleHelper;
import ej.service.ServiceFactory;
import java.io.File;
import java.io.RandomAccessFile;

public class OpenFile
extends AbstractFile {
    private final boolean writeMode;
    private final boolean overwrite;
    private final long overwritingSize;

    public OpenFile(File file, boolean writeMode, boolean overwrite) {
        super(file);
        this.writeMode = writeMode;
        this.overwrite = overwrite;
        this.overwritingSize = overwrite ? file.length() : 0L;
    }

    public OpenFile(File file) {
        this(file, false, false);
    }

    public OpenFile(RandomAccessFile file) {
        this(null, false, false);
    }

    public boolean isOverwritten() {
        return this.overwrite;
    }

    public boolean isWriteMode() {
        return this.writeMode;
    }

    public long getOverwritingSize() {
        return this.overwritingSize;
    }

    public void onStart() throws SecurityException {
        SandboxedModuleHelper cmh = (SandboxedModuleHelper)ServiceFactory.getRequiredService(SandboxedModuleHelper.class);
        SandboxedModule currentModule = cmh.getCurrentModule();
        currentModule.getFileSystemResourceController().onStart(currentModule, this);
    }

    public void onEnd(boolean endWithSuccess) {
        SandboxedModuleHelper cmh = (SandboxedModuleHelper)ServiceFactory.getRequiredService(SandboxedModuleHelper.class);
        SandboxedModule currentModule = cmh.getCurrentModule();
        currentModule.getFileSystemResourceController().onEnd(currentModule, this, endWithSuccess);
    }
}

