/*
 * Decompiled with CFR 0.152.
 */
package com.microej.kf.util;

import com.microej.kf.util.AbstractKFList;
import ej.kf.Feature;
import ej.kf.Kernel;
import ej.kf.Module;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class KFList2<T>
extends AbstractKFList<T> {
    private Object[][] contextsToList = new Object[0][];

    @Override
    public synchronized boolean contains(Object element) {
        Object[] list;
        Object[][] contextToLists = this.contextsToList;
        Module owner = Kernel.getContextOwner();
        int listIndex = KFList2.getContextListIndex(contextToLists, owner);
        if (listIndex == -1) {
            return false;
        }
        Object[] objectArray = list = contextToLists[listIndex];
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            Object e = objectArray[n2];
            if (e.equals(element)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public synchronized boolean add(T element) {
        Module owner = Kernel.getContextOwner();
        if (owner == Kernel.getInstance() && Kernel.getOwner(element) != owner) {
            throw new IllegalArgumentException();
        }
        Object[][] contextToLists = this.contextsToList;
        int listIndex = KFList2.getContextListIndex(contextToLists, owner);
        if (listIndex == -1) {
            Object[] list = new Object[]{element};
            Kernel.enter();
            try {
                int nbContexts = contextToLists.length;
                this.contextsToList = new Object[nbContexts + 1][];
                System.arraycopy(contextToLists, 0, this.contextsToList, 0, nbContexts);
                this.contextsToList[nbContexts] = list;
            }
            finally {
                Kernel.exit();
            }
        }
        Object[] list = contextToLists[listIndex];
        int nbElements = list.length;
        Object[] objectArray = list;
        list = new Object[nbElements + 1];
        System.arraycopy(objectArray, 0, list, 0, nbElements);
        list[nbElements] = element;
        Kernel.enter();
        try {
            contextToLists[listIndex] = list;
        }
        finally {
            Kernel.exit();
        }
        return true;
    }

    @Override
    public synchronized boolean remove(Object element) {
        Module owner = Kernel.getContextOwner();
        if (owner == Kernel.getInstance() && Kernel.getOwner((Object)element) != owner) {
            throw new IllegalArgumentException();
        }
        Object[][] contextToLists = this.contextsToList;
        int listIndex = KFList2.getContextListIndex(contextToLists, owner);
        if (listIndex == -1) {
            return false;
        }
        Object[] list = contextToLists[listIndex];
        int elementIndex = -1;
        int nbElements = list.length;
        int i = 0;
        while (i < nbElements) {
            if (list[i].equals(element)) {
                elementIndex = i;
                break;
            }
            ++i;
        }
        if (elementIndex == -1) {
            return false;
        }
        if (nbElements == 1) {
            Kernel.enter();
            try {
                this.contextsToList = this.removeContextListIndex(contextToLists, listIndex);
            }
            finally {
                Kernel.exit();
            }
        }
        Object[] newList = new Object[nbElements - 1];
        KFList2.copyExceptIndex(list, elementIndex, newList);
        Kernel.enter();
        try {
            this.contextsToList[listIndex] = newList;
        }
        finally {
            Kernel.exit();
        }
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        Module owner = Kernel.getContextOwner();
        Object[][] contextToLists = this.contextsToList;
        if (owner == Kernel.getInstance()) {
            return new ContextListIterator(contextToLists);
        }
        int listIndex = KFList2.getContextListIndex(contextToLists, owner);
        if (listIndex == -1) {
            return new ArrayList(0).iterator();
        }
        return new ListIterator(contextToLists[listIndex]);
    }

    @Override
    public synchronized boolean addAll(Collection<? extends T> c) {
        boolean result = false;
        for (T e : c) {
            result |= this.add(e);
        }
        return result;
    }

    @Override
    public synchronized void clear() {
        Module owner = Kernel.getContextOwner();
        if (owner == Kernel.getInstance()) {
            Kernel.enter();
            try {
                this.contextsToList = new Object[0][];
            }
            finally {
                Kernel.exit();
            }
        }
        Object[][] contextToLists = this.contextsToList;
        int listIndex = KFList2.getContextListIndex(contextToLists, owner);
        if (listIndex == -1) {
            return;
        }
        Kernel.enter();
        try {
            this.contextsToList = this.removeContextListIndex(contextToLists, listIndex);
        }
        finally {
            Kernel.exit();
        }
    }

    @Override
    public synchronized boolean isEmpty() {
        Module owner = Kernel.getContextOwner();
        Object[][] contextToLists = this.contextsToList;
        if (owner == Kernel.getInstance()) {
            return contextToLists.length == 0;
        }
        int listIndex = KFList2.getContextListIndex(contextToLists, owner);
        if (listIndex == -1) {
            return true;
        }
        Object[] list = contextToLists[listIndex];
        return list.length == 0;
    }

    @Override
    public synchronized int size() {
        Module owner = Kernel.getContextOwner();
        if (owner == Kernel.getInstance()) {
            int size = 0;
            Object[][] objectArray = this.contextsToList;
            int n = this.contextsToList.length;
            int n2 = 0;
            while (n2 < n) {
                Object[] list = objectArray[n2];
                size += list.length;
                ++n2;
            }
            return size;
        }
        Object[][] contextToLists = this.contextsToList;
        int listIndex = KFList2.getContextListIndex(contextToLists, owner);
        if (listIndex == -1) {
            return 0;
        }
        Object[] list = contextToLists[listIndex];
        return list.length;
    }

    @Override
    protected void toArray(ArrayList<T> allList) {
        Object[][] contextToLists = this.contextsToList;
        if (Kernel.isInKernelMode()) {
            Object[][] objectArray = contextToLists;
            int n = contextToLists.length;
            int n2 = 0;
            while (n2 < n) {
                Object[] list = objectArray[n2];
                KFList2.addAll(allList, list);
                ++n2;
            }
        } else {
            Module owner = Kernel.getContextOwner();
            int listIndex = KFList2.getContextListIndex(contextToLists, owner);
            if (listIndex != -1) {
                Object[] list = contextToLists[listIndex];
                KFList2.addAll(allList, list);
            }
        }
    }

    @Override
    protected void removeAllElementsOwnedBy(Feature feature) {
        Object[][] contextToLists = this.contextsToList;
        int listIndex = KFList2.getContextListIndex(contextToLists, (Module)feature);
        if (listIndex != -1) {
            this.contextsToList = this.removeContextListIndex(contextToLists, listIndex);
        }
    }

    private static int getContextListIndex(Object[][] list, Module context) {
        Kernel.enter();
        int length = list.length;
        int i = 0;
        while (i < length) {
            if (Kernel.getOwner((Object)list[i]) == context) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private Object[][] removeContextListIndex(Object[][] contextToLists, int listIndex) {
        Object[][] newContextsToList = new Object[contextToLists.length - 1][];
        KFList2.copyExceptIndex(contextToLists, listIndex, newContextsToList);
        return newContextsToList;
    }

    private static <T> void copyExceptIndex(T[] from, int index, T[] to) {
        int length;
        if (index > 0) {
            System.arraycopy(from, 0, to, 0, index);
        }
        if (index < (length = from.length) - 1) {
            System.arraycopy(from, index + 1, to, index, length - index - 1);
        }
    }

    private static <T> void addAll(ArrayList<T> allList, Object[] list) {
        int i = 0;
        while (i < list.length) {
            allList.add(list[i]);
            ++i;
        }
    }

    class ContextListIterator
    implements Iterator<T> {
        private final Object[][] contextToLists;
        private Iterator<T> currentIterator;
        private int nextIteratorIndex;

        public ContextListIterator(Object[][] contextToLists) {
            this.contextToLists = contextToLists;
            this.nextIteratorIndex = 0;
        }

        @Override
        public boolean hasNext() {
            int nbIterators = this.contextToLists.length;
            while (this.nextIteratorIndex < nbIterators) {
                if (this.currentIterator == null) {
                    this.currentIterator = new ListIterator(this.contextToLists[this.nextIteratorIndex]);
                }
                if (this.currentIterator.hasNext()) {
                    return true;
                }
                this.currentIterator = null;
                ++this.nextIteratorIndex;
            }
            return false;
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                return this.currentIterator.next();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.currentIterator == null) {
                throw new IllegalStateException();
            }
            this.currentIterator.remove();
        }
    }

    class ListIterator
    implements Iterator<T> {
        private final Object[] list;
        private int listPtr;

        public ListIterator(Object[] list) {
            this.list = list;
            this.listPtr = -1;
        }

        @Override
        public boolean hasNext() {
            return this.listPtr < this.list.length - 1;
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                return this.list[++this.listPtr];
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

