/*
 * Java
 *
 * Copyright 2023-2025 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package com.microej.kf.util.service;

import ej.service.ServiceFactory;
import ej.service.loader.CompositeServiceLoader;
import ej.service.loader.SystemPropertiesServiceLoader;

/**
 * KF Service loader that add several service loader according the KF specification
 */
public class ServiceLoaderKF extends CompositeServiceLoader {

	public ServiceLoaderKF() {
		// add service loaders according the specification (local (delegates action to
		// shared if needed) => system properties
		addServiceLoader(ServiceFactory.getServiceRegistry());
		addServiceLoader(new SystemPropertiesServiceLoader());
	}

}
