/*
 * Java
 *
 * Copyright 2025 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */

package com.microej.kf.util.policy;

/**
 * This enum represents the field names of a JSON policy file.
 */
public enum FeaturePolicySchema {
	/** Priority field name. */
	PRIORITY("priority"),
	/** Criticality field name. */
	CRITICALITY("criticality"),
	/** Resources section name. */
	RESOURCES("resources"),
	/** Limitations section name. */
	LIMIT("limit"),
	/** CPU limitation field name. */
	CPU("cpu"),
	/** RAM limitation field name. */
	RAM("ram"),
	/** Flash limitation field name. */
	FLASH("flash"),
	/** Network data section name. */
	NET_DATA("networkData"),
	/** Upstream section name. */
	NET_UPSTREAM("upstream"),
	/** Daily data limit field name. */
	NET_LIMIT("dailyDataLimit"),
	/** Subnet field name. */
	NET_SUBNET("cidrSubnet");

	/** String value of a field. */
	private final String value;

	FeaturePolicySchema(String value) {
		this.value = value;
	}

	/**
	 * Returns the name of each field.
	 *
	 * @return the string value representing a field.
	 */
	@Override
	public String toString() {
		return value;
	}
}
