/*
 * Java
 *
 * Copyright 2018-2025 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package com.microej.kf.util;

import ej.kf.Converter;
import ej.kf.Feature;
import ej.kf.Kernel;

/**
 * A {@link Converter} for {@link Double}. This converter creates a clone of the original {@link Double}.
 */
public class DoubleConverter implements Converter<Double> {

	@Override
	public Double convert(Double arg0, Feature targetOwner) throws IllegalAccessError {
		final double value = arg0.doubleValue();
		RunnableWithResult<Double> runnable = new RunnableWithResult<Double>() {
			@Override
			public Double runWithResult() {
				return new Double(value);
			}
		};
		Kernel.runUnderContext(targetOwner, runnable);
		return runnable.getResult();
	}

	@Override
	public Class<Double> getType() {
		return Double.class;
	}

}