/*
 * Java
 *
 * Copyright 2018-2025 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package com.microej.kf.util;

import ej.kf.Converter;
import ej.kf.Feature;
import ej.kf.Kernel;

/**
 * A {@link Converter} for {@link Character}. This converter creates a clone of the original {@link Character}.
 */
public class CharacterConverter implements Converter<Character> {

	@Override
	public Character convert(Character arg0, Feature targetOwner) throws IllegalAccessError {
		final char value = arg0.charValue();
		RunnableWithResult<Character> runnable = new RunnableWithResult<Character>() {
			@Override
			public Character runWithResult() {
				return new Character(value);
			}
		};
		Kernel.runUnderContext(targetOwner, runnable);
		return runnable.getResult();
	}

	@Override
	public Class<Character> getType() {
		return Character.class;
	}

}