/*
 * Java
 *
 * Copyright 2022-2025 MicroEJ Corp.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.microvg;

import java.io.Closeable;

/**
 * Represents a vector image which requires dynamic allocation in order to be created.
 * <p>
 * A resource vector image must be closed in order to free the dynamic allocation used to store the image data.
 */
public class ResourceVectorImage extends VectorImage implements Closeable {

	/* package */ ResourceVectorImage() {
	}

	/**
	 * Returns whether this vector image has been closed or not.
	 *
	 * @return <code>true</code> if the vector image has been closed, <code>false</code> otherwise.
	 */
	public boolean isClosed() {
		throw new VectorGraphicsException();
	}

	/**
	 * Closes this vector image and its associated resources.
	 * <p>
	 * Calling this method on a vector image which has already been closed has no effect.
	 */
	@Override
	public void close() {
		throw new VectorGraphicsException();
	}

	/**
	 * Loads a vector image from a path.
	 * <p>
	 * This method can load images which are in the internal image format defined by the MicroVG implementation. The
	 * caller is responsible for calling {@link ResourceVectorImage#close()} on the returned image when it is no longer
	 * used.
	 *
	 * @param resourcePath
	 *                         the path to get the image from
	 * @return a vector image
	 * @throws VectorGraphicsException
	 *                                     if the image could not be retrieved for any reason (see
	 *                                     {@link VectorGraphicsException#getErrorCode()})
	 * @since 1.2
	 */
	public static ResourceVectorImage loadImage(String resourcePath) {
		throw new VectorGraphicsException();
	}

}
