/*
 * Java
 *
 * Copyright 2015-2025 MicroEJ Corp.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.microui.event;

import java.security.Permission;

import ej.annotation.Nullable;

/**
 * This class is for event generator permissions.
 * <p>
 * The name is related to the event generator APIs and it symbolizes the permission's action.
 * <p>
 * The meaning of the possible permissions is defined as follows:
 * <dl>
 * <dt>set
 * <dd>set handler permission. Allows <code>EventGenerator.setEventHandler(EventHandler)</code> to be called.
 * </dl>
 */
public class EventPermission extends Permission {

	/**
	 * @param gen
	 *            the event generator.
	 * @deprecated use {@link #EventPermission(EventGenerator, String)}.
	 */
	@Deprecated
	public EventPermission(@Nullable EventGenerator gen) {
		super(null);
	}

	/**
	 * Creates a permission for events generated by the given event generator with the specified name.
	 *
	 * @param gen
	 *            the event generator.
	 * @param permission
	 *            the name of the <code>EventPermission</code>.
	 */
	public EventPermission(@Nullable EventGenerator gen, String permission) {
		super(null);
	}

	/**
	 * Gets the event generator handled by this permission.
	 *
	 * @return the event generator.
	 */
	public @Nullable EventGenerator getEventGenerator() {
		throw new RuntimeException();
	}

	@Override
	public boolean equals(@Nullable Object obj) {
		throw new RuntimeException();
	}

	@Override
	public String getActions() {
		throw new RuntimeException();
	}

	@Override
	public int hashCode() {
		throw new RuntimeException();
	}

	@Override
	public boolean implies(Permission permission) {
		throw new RuntimeException();
	}

}
