/*
 * Java
 *
 * Copyright 2023-2025 MicroEJ Corp.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.microui.display;

/**
 * Contains all the available buffer formats.
 */
public enum Format {
	/**
	 * Same format as the display.
	 * <p>
	 * It can be an alias for one of the other formats if the display uses a standard format. Otherwise, it represents
	 * the display custom format.
	 * <p>
	 * Useful to create a buffered image with the same format as the display for instance.
	 */
	DISPLAY,
	/**
	 * ARGB8888 format.
	 */
	ARGB8888,
	/**
	 * ARGB4444 format.
	 */
	ARGB4444,
	/**
	 * ARGB1555 format.
	 */
	ARGB1555,
	/**
	 * ARGB8888 pre-multiplied format (each color component is multiplied by the opacity).
	 */
	ARGB8888_PRE,
	/**
	 * ARGB4444 pre-multiplied format (each color component is multiplied by the opacity).
	 */
	ARGB4444_PRE,
	/**
	 * ARGB1555 pre-multiplied format (each color component is multiplied by the opacity).
	 */
	ARGB1555_PRE,
	/**
	 * RGB888 format.
	 */
	RGB888,
	/**
	 * RGB565 format.
	 */
	RGB565,
	/**
	 * A8 format.
	 */
	A8,
	/**
	 * A4 format.
	 */
	A4,
	/**
	 * A2 format.
	 */
	A2,
	/**
	 * A1 format.
	 */
	A1,
	/**
	 * C4 format.
	 */
	C4,
	/**
	 * C2 format.
	 */
	C2,
	/**
	 * C1 format.
	 */
	C1,
	/**
	 * AC44 format.
	 */
	AC44,
	/**
	 * AC22 format.
	 */
	AC22,
	/**
	 * AC11 format.
	 */
	AC11,

	/**
	 * Custom format 0.
	 */
	CUSTOM_0,
	/**
	 * Custom format 1.
	 */
	CUSTOM_1,
	/**
	 * Custom format 2.
	 */
	CUSTOM_2,
	/**
	 * Custom format 3.
	 */
	CUSTOM_3,
	/**
	 * Custom format 4.
	 */
	CUSTOM_4,
	/**
	 * Custom format 5.
	 */
	CUSTOM_5,
	/**
	 * Custom format 6.
	 */
	CUSTOM_6,
	/**
	 * Custom format 7.
	 */
	CUSTOM_7;

	/**
	 * Returns the SNI context data of this format.
	 * <p>
	 * The SNI context can be used to call a native method with SNI. This allows to identify the format in the native
	 * world.
	 * <p>
	 * The data format is implementation specific.
	 *
	 * @return the SNI context of this format.
	 */
	public byte getSNIContext() {
		throw new RuntimeException();
	}

}