/*
 * Java
 *
 * Copyright 2024-2025 MicroEJ Corp. All rights reserved.
 * MicroEJ Corp. PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.microui.display;

/**
 * Enumerates all MicroUI Font RAW formats.
 */
public enum MicroUIFontFormat {
	/**
	 * Defines a font whose format is Platform dependent.
	 */
	MICROUI_FONT_FORMAT_CUSTOM_7,

	/**
	 * Defines a font whose format is Platform dependent.
	 */
	MICROUI_FONT_FORMAT_CUSTOM_6,

	/**
	 * Defines a font whose format is Platform dependent.
	 */
	MICROUI_FONT_FORMAT_CUSTOM_5,

	/**
	 * Defines a font whose format is Platform dependent.
	 */
	MICROUI_FONT_FORMAT_CUSTOM_4,

	/**
	 * Defines a font whose format is Platform dependent.
	 */
	MICROUI_FONT_FORMAT_CUSTOM_3,

	/**
	 * Defines a font whose format is Platform dependent.
	 */
	MICROUI_FONT_FORMAT_CUSTOM_2,

	/**
	 * Defines a font whose format is Platform dependent.
	 */
	MICROUI_FONT_FORMAT_CUSTOM_1,

	/**
	 * Defines a font whose format is Platform dependent.
	 */
	MICROUI_FONT_FORMAT_CUSTOM_0,

	/**
	 * Defines a font whose format is MicroUI implementation dependent.
	 */
	MICROUI_FONT_FORMAT_INTERNAL,
}
