/*
 * Copyright 2024-2025 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package com.microej.wear.components;

import ej.microui.display.GraphicsContext;

/**
 * Represents an activity.
 */
public interface Activity {

	/**
	 * Gets the name of this activity.
	 *
	 * @return the name of this activity.
	 */
	String getName();

	/**
	 * Called when the icon is scheduled for imminent rendering.
	 * <p>
	 * For example, this method can load the resources necessary for rendering.
	 */
	void onIconAttached();

	/**
	 * Called when the icon is no longer scheduled for imminent rendering.
	 * <p>
	 * For example, this method can dispose of the resources loaded in {@link #onIconAttached()}.
	 */
	void onIconDetached();

	/**
	 * Renders the icon of this activity.
	 *
	 * @param g
	 *            the graphics context to draw with.
	 * @param x
	 *            the x coordinate of the region to draw in.
	 * @param y
	 *            the y coordinate of the region to draw in.
	 * @param size
	 *            the width and height of the region to draw in.
	 */
	void renderIcon(GraphicsContext g, int x, int y, int size);

	/**
	 * Creates a renderable that renders this activity.
	 * <p>
	 * This method is called when the activity is scheduled for imminent rendering. The renderable is then attached
	 * immediately by calling (see {@link Renderable#onAttached()}).
	 *
	 * @return the renderable.
	 */
	Renderable createRenderable();
}
