/*
 * Decompiled with CFR 0.152.
 */
package com.microej.kf.util.storage;

import ej.kf.Kernel;
import ej.kf.Module;
import ej.storage.fs.StorageFs;
import java.io.IOException;

public class SandboxedStorage
extends StorageFs {
    private static final String KERNEL_PARENT_PREFIX = "kernel";
    private static final String FEATURES_PARENT_PREFIX = "apps";

    public SandboxedStorage() throws IOException {
        this(SandboxedStorage.getRootFolderPropertyOrDefault());
    }

    public SandboxedStorage(String root) throws IOException {
        super(String.valueOf(root) + '/' + SandboxedStorage.getContextName(Kernel.getContextOwner()));
    }

    public String getRootFolder(Module module) {
        return String.valueOf(SandboxedStorage.getRootFolderPropertyOrDefault()) + '/' + SandboxedStorage.getContextName(module);
    }

    private static String getContextName(Module module) {
        if (module == Kernel.getInstance()) {
            return KERNEL_PARENT_PREFIX;
        }
        return "apps/" + module.getName();
    }
}

